<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%profile_history}}`.
 */
class m260206_162756_create_profile_history_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%profile_history}}', [
            'id' => $this->primaryKey(),
            'profile_id' => $this->integer()->notNull(),
            'field_name' => $this->string(100)->notNull(),
            'old_value' => $this->text(),
            'new_value' => $this->text(),
            'changed_by' => $this->integer()->notNull(),
            'changed_at' => $this->integer()->notNull(),
        ], $tableOptions);

        // Внешний ключ и индексы
        $this->addForeignKey(
            'fk-profile_history-profile_id',
            '{{%profile_history}}',
            'profile_id',
            '{{%employee_profile}}',
            'id',
            'CASCADE',
            'CASCADE'
        );

        $this->addForeignKey(
            'fk-profile_history-changed_by',
            '{{%profile_history}}',
            'changed_by',
            '{{%user}}',
            'id',
            'CASCADE',
            'CASCADE'
        );

        $this->createIndex('idx-history-profile_id', '{{%profile_history}}', 'profile_id');
        $this->createIndex('idx-history-field_name', '{{%profile_history}}', 'field_name');
        $this->createIndex('idx-history-changed_at', '{{%profile_history}}', 'changed_at');
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%profile_history}}');
    }
}
