<?php

/* @var $this \yii\web\View */
/* @var $content string */

use yii\helpers\Html;
use yii\helpers\Url;

$appName = 'Отдел кадров';
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?= Html::csrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?> | <?= $appName ?></title>
    
    <style>
        /* Основные стили */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 15px;
        }
        
        /* Шапка */
        .header {
            background: linear-gradient(90deg, #1a237e 0%, #283593 100%);
            color: white;
            padding: 1rem 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 1000;
        }
        
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .logo {
            display: flex;
            align-items: center;
            gap: 10px;
            text-decoration: none;
            color: white;
            font-weight: bold;
            font-size: 1.5rem;
        }
        
        .logo:hover {
            opacity: 0.9;
        }
        
        /* Навигация */
        .nav {
            display: flex;
            gap: 20px;
            align-items: center;
        }
        
        .nav-link {
            color: white;
            text-decoration: none;
            padding: 8px 16px;
            border-radius: 4px;
            transition: all 0.3s ease;
            font-weight: 500;
        }
        
        .nav-link:hover {
            background: rgba(255,255,255,0.1);
            transform: translateY(-2px);
        }
        
        .nav-link.active {
            background: rgba(255,255,255,0.2);
        }
        
        .username {
            color: #e3f2fd;
            font-weight: 500;
            margin-right: 10px;
        }
        
        /* Основной контент */
        .main-content {
            padding: 30px 0;
            animation: fadeIn 0.5s ease-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        /* Футер */
        .footer {
            background: #1a237e;
            color: white;
            padding: 2rem 0;
            margin-top: auto;
        }
        
        .footer-content {
            text-align: center;
        }
        
        /* Карточки */
        .card {
            background: white;
            border-radius: 10px;
            padding: 30px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
            margin-bottom: 30px;
            animation: slideUp 0.5s ease-out;
        }
        
        @keyframes slideUp {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        /* Формы */
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #444;
        }
        
        .form-control {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #ddd;
            border-radius: 6px;
            font-size: 16px;
            transition: all 0.3s ease;
        }
        
        .form-control:focus {
            border-color: #3949ab;
            box-shadow: 0 0 0 3px rgba(57, 73, 171, 0.1);
            outline: none;
        }
        
        .form-control.error {
            border-color: #e53935;
        }
        
        .error-message {
            color: #e53935;
            font-size: 14px;
            margin-top: 5px;
            display: block;
        }
        
        /* Кнопки */
        .btn {
            display: inline-block;
            padding: 12px 30px;
            border: none;
            border-radius: 6px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
            text-align: center;
        }
        
        .btn-primary {
            background: linear-gradient(45deg, #3949ab, #5c6bc0);
            color: white;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(57, 73, 171, 0.3);
        }
        
        .btn-secondary {
            background: #78909c;
            color: white;
        }
        
        .btn-block {
            width: 100%;
        }
        
        /* Алерты */
        .alert {
            padding: 15px 20px;
            border-radius: 6px;
            margin-bottom: 20px;
            animation: slideInRight 0.5s ease-out;
        }
        
        @keyframes slideInRight {
            from { transform: translateX(100%); opacity: 0; }
            to { transform: translateX(0); opacity: 1; }
        }
        
        .alert-success {
            background: #e8f5e9;
            color: #2e7d32;
            border-left: 4px solid #4caf50;
        }
        
        .alert-error {
            background: #ffebee;
            color: #c62828;
            border-left: 4px solid #f44336;
        }
        
        /* Сетка */
        .row {
            display: flex;
            flex-wrap: wrap;
            margin: 0 -15px;
        }
        
        .col {
            padding: 0 15px;
            flex: 1;
        }
        
        .col-6 {
            width: 50%;
            padding: 0 15px;
        }
        
        .col-12 {
            width: 100%;
            padding: 0 15px;
        }
        
        /* Утилиты */
        .text-center { text-align: center; }
        .mt-3 { margin-top: 1rem; }
        .mb-3 { margin-bottom: 1rem; }
        .mt-4 { margin-top: 1.5rem; }
        .mb-4 { margin-bottom: 1.5rem; }
        
        /* Адаптивность */
        @media (max-width: 768px) {
            .header-content {
                flex-direction: column;
                gap: 15px;
            }
            
            .nav {
                flex-wrap: wrap;
                justify-content: center;
            }
            
            .col-6 {
                width: 100%;
            }
            
            .card {
                padding: 20px;
            }
        }
    </style>
    
    <?php $this->head() ?>
</head>
<body>
<?php $this->beginBody() ?>

<div class="header">
    <div class="container">
        <div class="header-content">
            <a href="<?= Url::to(['/site/index']) ?>" class="logo">
                <span>📋</span>
                <span><?= $appName ?></span>
            </a>
            
            <div class="nav">
                <?php if (!Yii::$app->user->isGuest): ?>
                    <?php if (Yii::$app->user->identity->isAdmin()): ?>
                        <a href="<?= Url::to(['/admin/index']) ?>" class="nav-link <?= Yii::$app->controller->id == 'admin' ? 'active' : '' ?>">
                            Панель администратора
                        </a>
                    <?php else: ?>
                        <a href="<?= Url::to(['/profile/index']) ?>" class="nav-link <?= Yii::$app->controller->id == 'profile' ? 'active' : '' ?>">
                            Личный кабинет
                        </a>
                        <a href="<?= Url::to(['/profile/create']) ?>" class="nav-link <?= Yii::$app->controller->id == 'profile' && Yii::$app->controller->action->id == 'create' ? 'active' : '' ?>">
                            Анкета
                        </a>
                    <?php endif; ?>
                    
                    <span class="username">
                        <?= Html::encode(Yii::$app->user->identity->full_name) ?>
                    </span>
                    
                    <a href="<?= Url::to(['/site/logout']) ?>" class="nav-link" 
                       onclick="return confirm('Вы уверены, что хотите выйти?')">
                        Выйти
                    </a>
                <?php else: ?>
                    <a href="<?= Url::to(['/site/login']) ?>" class="nav-link <?= Yii::$app->controller->action->id == 'login' ? 'active' : '' ?>">
                        Вход
                    </a>
                    <a href="<?= Url::to(['/site/register']) ?>" class="nav-link <?= Yii::$app->controller->action->id == 'register' ? 'active' : '' ?>">
                        Регистрация
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<div class="main-content">
    <div class="container">
        <?php if (Yii::$app->session->hasFlash('success')): ?>
            <div class="alert alert-success">
                <?= Yii::$app->session->getFlash('success') ?>
            </div>
        <?php endif; ?>
        
        <?php if (Yii::$app->session->hasFlash('error')): ?>
            <div class="alert alert-error">
                <?= Yii::$app->session->getFlash('error') ?>
            </div>
        <?php endif; ?>
        
        <?= $content ?>
    </div>
</div>

<div class="footer">
    <div class="container">
        <div class="footer-content">
            <p>© <?= date('Y') ?> Информационная система "Отдел кадров"</p>
            <p>Телефон поддержки: +7 (999) 123-45-67</p>
        </div>
    </div>
</div>

<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>