<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Заполнение анкеты';
$this->params['breadcrumbs'][] = $this->title;

$this->registerCss("
.anketa-container {
    max-width: 900px;
    margin: 0 auto;
}

.section {
    background: white;
    border-radius: 10px;
    padding: 30px;
    margin-bottom: 30px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    animation: slideUp 0.5s ease-out;
}

.section-title {
    color: #3949ab;
    margin-bottom: 25px;
    padding-bottom: 15px;
    border-bottom: 2px solid #e8eaf6;
    font-size: 1.5rem;
}

.form-row {
    display: flex;
    flex-wrap: wrap;
    margin: 0 -10px;
}

.form-group {
    padding: 0 10px;
    margin-bottom: 20px;
    flex: 1 0 300px;
}

.file-upload {
    border: 2px dashed #ddd;
    border-radius: 8px;
    padding: 30px;
    text-align: center;
    cursor: pointer;
    transition: all 0.3s ease;
    background: #fafafa;
}

.file-upload:hover {
    border-color: #3949ab;
    background: #f0f4ff;
}

.file-upload input[type='file'] {
    display: none;
}

.file-upload-label {
    display: flex;
    flex-direction: column;
    align-items: center;
    color: #666;
    cursor: pointer;
}

.file-preview {
    margin-top: 15px;
    font-size: 14px;
    color: #666;
}

.submit-section {
    text-align: center;
    padding: 40px 0;
}

.btn-submit {
    padding: 15px 50px;
    font-size: 18px;
    border-radius: 8px;
    background: linear-gradient(45deg, #4caf50, #66bb6a);
    border: none;
    color: white;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(76, 175, 80, 0.3);
}

.btn-submit:hover {
    transform: translateY(-3px);
    box-shadow: 0 6px 20px rgba(76, 175, 80, 0.4);
}

.progress-bar {
    width: 100%;
    height: 8px;
    background: #e0e0e0;
    border-radius: 4px;
    margin-bottom: 30px;
    overflow: hidden;
}

.progress-fill {
    height: 100%;
    background: linear-gradient(90deg, #4caf50, #66bb6a);
    width: 0%;
    transition: width 0.5s ease;
}

.step-indicator {
    display: flex;
    justify-content: space-between;
    margin-bottom: 30px;
    position: relative;
}

.step {
    display: flex;
    flex-direction: column;
    align-items: center;
    flex: 1;
    position: relative;
    z-index: 1;
}

.step-number {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: #e0e0e0;
    color: #666;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    margin-bottom: 10px;
    transition: all 0.3s ease;
}

.step.active .step-number {
    background: #3949ab;
    color: white;
    transform: scale(1.1);
}

.step-label {
    font-size: 14px;
    color: #666;
    text-align: center;
}

.step-connector {
    position: absolute;
    top: 20px;
    left: 0;
    right: 0;
    height: 2px;
    background: #e0e0e0;
    z-index: 0;
}

@keyframes slideUp {
    from { opacity: 0; transform: translateY(30px); }
    to { opacity: 1; transform: translateY(0); }
}

.section {
    display: none;
}

.section.active {
    display: block;
}

.form-label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    color: #444;
}

.form-control {
    width: 100%;
    padding: 12px 15px;
    border: 2px solid #ddd;
    border-radius: 6px;
    font-size: 16px;
    transition: all 0.3s ease;
}

.form-control:focus {
    border-color: #3949ab;
    box-shadow: 0 0 0 3px rgba(57, 73, 171, 0.1);
    outline: none;
}

.error-message {
    color: #e53935;
    font-size: 14px;
    margin-top: 5px;
    display: block;
}

.btn {
    display: inline-block;
    padding: 12px 30px;
    border: none;
    border-radius: 6px;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    text-align: center;
}

.file-info {
    font-size: 12px;
    color: #666;
    margin-top: 5px;
}
");

// JavaScript для работы формы
$js = <<<JS
// Многостраничная форма
let currentStep = 1;
const totalSteps = 4;

function showStep(step) {
    // Скрыть все секции
    document.querySelectorAll('.section').forEach(section => {
        section.classList.remove('active');
    });
    
    // Показать нужную секцию
    document.getElementById('section-' + step).classList.add('active');
    
    // Обновить индикатор
    document.querySelectorAll('.step').forEach((stepEl, index) => {
        if (index + 1 <= step) {
            stepEl.classList.add('active');
        } else {
            stepEl.classList.remove('active');
        }
    });
    
    // Обновить прогресс бар
    const progress = (step / totalSteps) * 100;
    document.querySelector('.progress-fill').style.width = progress + '%';
    
    currentStep = step;
    
    // Прокрутить к верху
    window.scrollTo({top: 0, behavior: 'smooth'});
}

function nextStep() {
    console.log('nextStep called, current step:', currentStep);
    
    // Проверяем только обязательные поля (не файлы)
    const currentSection = document.getElementById('section-' + currentStep);
    const requiredInputs = currentSection.querySelectorAll('[required]');
    console.log('Required inputs found:', requiredInputs.length);
    
    let valid = true;
    
    requiredInputs.forEach(input => {
        console.log('Checking input:', input.name, 'value:', input.value);
        
        // Для select проверяем выбранное значение
        if (input.tagName === 'SELECT') {
            if (!input.value || input.value === '') {
                console.log('Select is empty');
                input.style.borderColor = '#f44336';
                valid = false;
                // Показываем ошибку
                let errorDiv = input.parentElement.querySelector('.error-message');
                if (!errorDiv) {
                    errorDiv = document.createElement('div');
                    errorDiv.className = 'error-message';
                    errorDiv.textContent = 'Это поле обязательно для заполнения';
                    input.parentElement.appendChild(errorDiv);
                }
            } else {
                console.log('Select has value:', input.value);
                input.style.borderColor = '#ddd';
                // Убираем ошибку
                const errorDiv = input.parentElement.querySelector('.error-message');
                if (errorDiv) {
                    errorDiv.remove();
                }
            }
        } 
        // Для текстовых полей
        else if (!input.value.trim()) {
            console.log('Input is empty');
            input.style.borderColor = '#f44336';
            valid = false;
            // Показываем ошибку
            let errorDiv = input.parentElement.querySelector('.error-message');
            if (!errorDiv) {
                errorDiv = document.createElement('div');
                errorDiv.className = 'error-message';
                errorDiv.textContent = 'Это поле обязательно для заполнения';
                input.parentElement.appendChild(errorDiv);
            }
        } else {
            console.log('Input has value:', input.value);
            input.style.borderColor = '#ddd';
            // Убираем ошибку
            const errorDiv = input.parentElement.querySelector('.error-message');
            if (errorDiv) {
                errorDiv.remove();
            }
        }
    });
    
    console.log('Form valid:', valid);
    
    if (valid && currentStep < totalSteps) {
        showStep(currentStep + 1);
    } else if (!valid) {
        console.log('Form not valid, showing errors');
        // Анимация для незаполненных полей
        requiredInputs.forEach(input => {
            if ((input.tagName === 'SELECT' && !input.value) || 
                (input.tagName !== 'SELECT' && !input.value.trim())) {
                input.classList.add('shake-animation');
                setTimeout(() => {
                    input.classList.remove('shake-animation');
                }, 500);
            }
        });
    }
}

function prevStep() {
    if (currentStep > 1) {
        showStep(currentStep - 1);
    }
}

// Инициализация
showStep(1);

// Маска для СНИЛС
document.getElementById('employeeprofile-snils').addEventListener('input', function(e) {
    let value = e.target.value.replace(/[^\\d]/g, '');
    
    if (value.length > 11) value = value.substring(0, 11);
    
    if (value.length <= 3) {
        e.target.value = value;
    } else if (value.length <= 6) {
        e.target.value = value.substring(0, 3) + '-' + value.substring(3);
    } else if (value.length <= 9) {
        e.target.value = value.substring(0, 3) + '-' + value.substring(3, 6) + '-' + value.substring(6);
    } else {
        e.target.value = value.substring(0, 3) + '-' + value.substring(3, 6) + '-' + value.substring(6, 9) + ' ' + value.substring(9);
    }
});

// Маска для паспорта
document.getElementById('employeeprofile-passport_series').addEventListener('input', function(e) {
    this.value = this.value.replace(/[^0-9]/g, '').substring(0, 4);
});

document.getElementById('employeeprofile-passport_number').addEventListener('input', function(e) {
    this.value = this.value.replace(/[^0-9]/g, '').substring(0, 6);
});

// Предпросмотр файлов
function previewFile(input, previewId) {
    const file = input.files[0];
    const preview = document.getElementById(previewId);
    
    if (file) {
        const fileSize = (file.size / (1024*1024)).toFixed(2);
        // Проверяем размер файла
        if (file.size > 20 * 1024 * 1024) {
            preview.innerHTML = '<div style="background: #ffebee; padding: 10px; border-radius: 5px; color: #c62828;"><strong>' + file.name + '</strong><br>Размер: ' + fileSize + ' MB<br><strong>ОШИБКА: Файл слишком большой!</strong><br>Максимальный размер: 20MB</div>';
            input.value = ''; // Сбрасываем файл
            return;
        }
        
        preview.innerHTML = '<div style="background: #e8f5e9; padding: 10px; border-radius: 5px;"><strong>' + file.name + '</strong><br>Размер: ' + fileSize + ' MB<br>Тип: ' + file.type + '</div>';
        
        // Добавляем стиль для валидного файла
        input.parentElement.parentElement.style.borderColor = '#4caf50';
    } else {
        preview.innerHTML = '';
        // Возвращаем стандартный стиль
        input.parentElement.parentElement.style.borderColor = '#ddd';
    }
}

// Обработка клика по области загрузки файлов
document.querySelectorAll('.file-upload').forEach(uploadArea => {
    const fileInput = uploadArea.querySelector('input[type="file"]');
    const previewId = uploadArea.nextElementSibling.id;
    
    uploadArea.addEventListener('click', function() {
        fileInput.click();
    });
    
    fileInput.addEventListener('change', function() {
        previewFile(this, previewId);
    });
});

// Анимация при отправке формы
document.getElementById('anketa-form').addEventListener('submit', function(e) {
    const btn = document.getElementById('submit-btn');
    btn.innerHTML = '<span style="display:inline-block;width:24px;height:24px;border:2px solid #fff;border-radius:50%;border-top-color:transparent;animation:spin 1s linear infinite;margin-right:10px;"></span>Отправка данных...';
    btn.disabled = true;
    
    // Показываем прогресс отправки
    const progressBar = document.querySelector('.progress-fill');
    progressBar.style.background = 'linear-gradient(90deg, #2196f3, #21cbf3)';
    progressBar.style.width = '100%';
});

// Добавляем CSS анимации
const style = document.createElement('style');
style.textContent = '@keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } } @keyframes shake { 0%, 100% { transform: translateX(0); } 10%, 30%, 50%, 70%, 90% { transform: translateX(-5px); } 20%, 40%, 60%, 80% { transform: translateX(5px); } } .shake-animation { animation: shake 0.5s ease-in-out; }';
document.head.appendChild(style);

// Функция проверки всех полей
function checkAllFields() {
    let allValid = true;
    const allSections = document.querySelectorAll('.section');
    
    // Сбрасываем все ошибки
    document.querySelectorAll('.error-message').forEach(error => error.remove());
    document.querySelectorAll('.form-control').forEach(input => input.style.borderColor = '#ddd');
    
    allSections.forEach(section => {
        const requiredInputs = section.querySelectorAll('[required]');
        
        requiredInputs.forEach(input => {
            // Для select проверяем выбранное значение
            if (input.tagName === 'SELECT') {
                if (!input.value || input.value === '') {
                    input.style.borderColor = '#f44336';
                    allValid = false;
                    
                    // Показываем ошибку
                    let errorDiv = input.parentElement.querySelector('.error-message');
                    if (!errorDiv) {
                        errorDiv = document.createElement('div');
                        errorDiv.className = 'error-message';
                        errorDiv.textContent = 'Это поле обязательно для заполнения';
                        input.parentElement.appendChild(errorDiv);
                    }
                }
            } 
            // Для текстовых полей
            else if (!input.value.trim()) {
                input.style.borderColor = '#f44336';
                allValid = false;
                
                // Показываем ошибку
                let errorDiv = input.parentElement.querySelector('.error-message');
                if (!errorDiv) {
                    errorDiv = document.createElement('div');
                    errorDiv.className = 'error-message';
                    errorDiv.textContent = 'Это поле обязательно для заполнения';
                    input.parentElement.appendChild(errorDiv);
                }
            }
        });
    });
    
    if (allValid) {
        // Прокручиваем к кнопке отправки
        document.querySelector('.submit-section').scrollIntoView({behavior: 'smooth'});
    } else {
        alert('Пожалуйста, заполните все обязательные поля перед отправкой.');
        // Возвращаем к первому незаполненному полю
        const firstError = document.querySelector('.form-control[style*="border-color: rgb(244, 67, 54)"]');
        if (firstError) {
            firstError.scrollIntoView({behavior: 'smooth', block: 'center'});
        }
    }
}
JS;

$this->registerJs($js);
?>

<div class="anketa-container">
    <h1 class="text-center" style="margin-bottom: 40px; color: #3949ab;">
        <span style="font-size: 2.5rem;">📋</span><br>
        Анкета сотрудника
    </h1>
    
    <div class="progress-bar">
        <div class="progress-fill"></div>
    </div>
    
    <div class="step-indicator">
        <div class="step active">
            <div class="step-number">1</div>
            <div class="step-label">Личные данные</div>
        </div>
        <div class="step">
            <div class="step-number">2</div>
            <div class="step-label">Паспортные данные</div>
        </div>
        <div class="step">
            <div class="step-number">3</div>
            <div class="step-label">Образование</div>
        </div>
        <div class="step">
            <div class="step-number">4</div>
            <div class="step-label">Работа и прочее</div>
        </div>
        <div class="step-connector"></div>
    </div>

    <?php $form = ActiveForm::begin([
        'id' => 'anketa-form',
        'options' => ['enctype' => 'multipart/form-data', 'class' => 'form'],
        'fieldConfig' => [
            'template' => "{label}\n{input}\n{error}",
            'labelOptions' => ['class' => 'form-label'],
            'inputOptions' => ['class' => 'form-control'],
            'errorOptions' => ['class' => 'error-message'],
        ],
    ]); ?>

    <!-- Шаг 1: Личные данные -->
    <div id="section-1" class="section active">
        <h2 class="section-title">
            <span>👤</span> Личные данные
        </h2>
        
        <div class="form-row">
            <div class="form-group">
                <?= $form->field($model, 'full_name')->textInput([
                    'value' => $user->full_name,
                    'readonly' => true,
                    'style' => 'background: #f5f5f5;'
                ]) ?>
            </div>
            
            <div class="form-group">
                <?= $form->field($model, 'birth_date')->textInput([
                    'type' => 'date',
                    'max' => date('Y-m-d', strtotime('-18 years')),
                    'required' => true
                ]) ?>
            </div>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <?= $form->field($model, 'gender')->dropDownList($model->getGenderList(), [
                    'prompt' => '-- Выберите пол --',
                    'required' => true
                ]) ?>
            </div>
            
            <div class="form-group">
                <?= $form->field($model, 'citizenship')->textInput([
                    'placeholder' => 'Российская Федерация',
                    'required' => true
                ]) ?>
            </div>
        </div>
        
        <div class="form-group">
            <label class="form-label">Фото сотрудника (необязательно)</label>
            <div class="file-upload">
                <label class="file-upload-label">
                    <span style="font-size: 48px;">📷</span>
                    <span>Нажмите для загрузки фото</span>
                    <span class="file-info">
                        Форматы: JPG, PNG, PDF | Макс. размер: 10MB
                    </span>
                    <?= $form->field($model, 'photoFile')->fileInput([
                        'style' => 'display: none;'
                    ])->label(false) ?>
                </label>
            </div>
            <div id="photo-preview" class="file-preview"></div>
        </div>
        
        <div style="text-align: center; margin-top: 30px;">
            <button type="button" class="btn" onclick="nextStep()" 
                    style="background: #3949ab; color: white; padding: 12px 40px;">
                Далее <span style="margin-left: 5px;">→</span>
            </button>
        </div>
    </div>

    <!-- Шаг 2: Паспортные данные -->
    <div id="section-2" class="section">
        <h2 class="section-title">
            <span>🛂</span> Паспортные данные
        </h2>
        
        <div class="form-row">
            <div class="form-group">
                <?= $form->field($model, 'passport_series')->textInput([
                    'placeholder' => '0000',
                    'required' => true
                ]) ?>
            </div>
            
            <div class="form-group">
                <?= $form->field($model, 'passport_number')->textInput([
                    'placeholder' => '000000',
                    'required' => true
                ]) ?>
            </div>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <?= $form->field($model, 'passport_issued_by')->textInput([
                    'placeholder' => 'ОУФМС России по...',
                    'required' => true
                ]) ?>
            </div>
            
            <div class="form-group">
                <?= $form->field($model, 'passport_issue_date')->textInput([
                    'type' => 'date',
                    'required' => true
                ]) ?>
            </div>
        </div>
        
        <div class="form-group">
            <?= $form->field($model, 'passport_registration')->textarea([
                'rows' => 3,
                'placeholder' => 'Адрес регистрации по месту жительства...',
                'required' => true
            ]) ?>
        </div>
        
        <div class="form-group">
            <?= $form->field($model, 'marital_status')->dropDownList($model->getMaritalStatusList(), [
                'prompt' => '-- Выберите семейное положение --',
                'required' => true
            ]) ?>
        </div>
        
        <div class="form-group">
            <label class="form-label">Скан паспорта (необязательно)</label>
            <div class="file-upload">
                <label class="file-upload-label">
                    <span style="font-size: 48px;">📄</span>
                    <span>Загрузите скан паспорта</span>
                    <span class="file-info">
                        Форматы: JPG, PNG, PDF | Макс. размер: 20MB
                    </span>
                    <?= $form->field($model, 'passportScanFile')->fileInput([
                        'style' => 'display: none;'
                    ])->label(false) ?>
                </label>
            </div>
            <div id="passport-preview" class="file-preview"></div>
        </div>
        
        <div style="text-align: center; margin-top: 30px;">
            <button type="button" class="btn" onclick="prevStep()" 
                    style="background: #78909c; color: white; padding: 12px 30px; margin-right: 15px;">
                ← Назад
            </button>
            <button type="button" class="btn" onclick="nextStep()" 
                    style="background: #3949ab; color: white; padding: 12px 40px;">
                Далее <span style="margin-left: 5px;">→</span>
            </button>
        </div>
    </div>

    <!-- Шаг 3: Образование -->
    <div id="section-3" class="section">
        <h2 class="section-title">
            <span>🎓</span> Образование
        </h2>
        
        <div class="form-group">
            <?= $form->field($model, 'education')->dropDownList($model->getEducationList(), [
                'prompt' => '-- Выберите уровень образования --',
                'required' => true
            ]) ?>
        </div>
        
        <div class="form-group">
            <?= $form->field($model, 'education_organization')->textInput([
                'placeholder' => 'Например: МГУ им. Ломоносова',
                'required' => true
            ]) ?>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <?= $form->field($model, 'specialty')->textInput([
                    'placeholder' => 'Например: Программная инженерия',
                    'required' => true
                ]) ?>
            </div>
            
            <div class="form-group">
                <?= $form->field($model, 'qualification')->textInput([
                    'placeholder' => 'Например: Бакалавр',
                    'required' => true
                ]) ?>
            </div>
        </div>
        
        <div class="form-group">
            <?= $form->field($model, 'diploma_number')->textInput([
                'placeholder' => 'Номер диплома',
                'required' => true
            ]) ?>
        </div>
        
        <div class="form-group">
            <label class="form-label">Скан диплома (необязательно)</label>
            <div class="file-upload">
                <label class="file-upload-label">
                    <span style="font-size: 48px;">📑</span>
                    <span>Загрузите скан диплома</span>
                    <span class="file-info">
                        Форматы: JPG, PNG, PDF | Макс. размер: 20MB
                    </span>
                    <?= $form->field($model, 'diplomaScanFile')->fileInput([
                        'style' => 'display: none;'
                    ])->label(false) ?>
                </label>
            </div>
            <div id="diploma-preview" class="file-preview"></div>
        </div>
        
        <div style="text-align: center; margin-top: 30px;">
            <button type="button" class="btn" onclick="prevStep()" 
                    style="background: #78909c; color: white; padding: 12px 30px; margin-right: 15px;">
                ← Назад
            </button>
            <button type="button" class="btn" onclick="nextStep()" 
                    style="background: #3949ab; color: white; padding: 12px 40px;">
                Далее <span style="margin-left: 5px;">→</span>
            </button>
        </div>
    </div>

    <!-- Шаг 4: Работа и прочее -->
    <div id="section-4" class="section">
        <h2 class="section-title">
            <span>💼</span> Работа и дополнительная информация
        </h2>
        
        <div class="form-row">
            <div class="form-group">
                <?= $form->field($model, 'workplace')->textInput([
                    'placeholder' => 'Название организации',
                    'required' => true
                ]) ?>
            </div>
            
            <div class="form-group">
                <?= $form->field($model, 'position')->textInput([
                    'placeholder' => 'Должность',
                    'required' => true
                ]) ?>
            </div>
        </div>
        
        <div class="form-group">
            <?= $form->field($model, 'experience')->textInput([
                'type' => 'number',
                'min' => 0,
                'placeholder' => 'Стаж в месяцах',
                'required' => true
            ]) ?>
        </div>
        
        <div class="form-group">
            <?= $form->field($model, 'snils')->textInput([
                'placeholder' => '000-000-000 00',
                'required' => true
            ]) ?>
        </div>
        
        <div class="form-group">
            <label class="form-label">Скан СНИЛС (необязательно)</label>
            <div class="file-upload">
                <label class="file-upload-label">
                    <span style="font-size: 48px;">🆔</span>
                    <span>Загрузите скан СНИЛС</span>
                    <span class="file-info">
                        Форматы: JPG, PNG, PDF | Макс. размер: 10MB
                    </span>
                    <?= $form->field($model, 'snilsScanFile')->fileInput([
                        'style' => 'display: none;'
                    ])->label(false) ?>
                </label>
            </div>
            <div id="snils-preview" class="file-preview"></div>
        </div>
        
        <div class="form-group">
            <?= $form->field($model, 'health_status')->textarea([
                'rows' => 3,
                'placeholder' => 'Опишите состояние здоровья, хронические заболевания, аллергии и т.д.'
            ]) ?>
        </div>
        
        <div class="form-group">
            <?= $form->field($model, 'additional_info')->textarea([
                'rows' => 4,
                'placeholder' => 'Дополнительная информация, которую считаете нужной указать...'
            ]) ?>
        </div>
        
        <div style="text-align: center; margin-top: 30px;">
            <button type="button" class="btn" onclick="prevStep()" 
                    style="background: #78909c; color: white; padding: 12px 30px; margin-right: 15px;">
                ← Назад
            </button>
            <button type="button" class="btn" 
                    style="background: #3949ab; color: white; padding: 12px 40px; margin-right: 15px;"
                    onclick="checkAllFields()">
                Проверить и отправить
            </button>
        </div>
        
        <div class="submit-section">
            <p style="color: #666; margin-bottom: 20px;">
                Проверьте все введенные данные перед отправкой.
            </p>
            <?= Html::submitButton('Отправить анкету на проверку', [
                'class' => 'btn-submit',
                'id' => 'submit-btn'
            ]) ?>
        </div>
    </div>

    <?php ActiveForm::end(); ?>
</div>