<?php

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Главная';

$this->registerCss("
.hero {
    text-align: center;
    padding: 60px 0;
    background: linear-gradient(135deg, #3949ab 0%, #5c6bc0 100%);
    color: white;
    border-radius: 10px;
    margin-bottom: 50px;
    animation: fadeIn 1s ease-out;
}

.hero h1 {
    font-size: 3rem;
    margin-bottom: 20px;
}

.hero p {
    font-size: 1.2rem;
    max-width: 700px;
    margin: 0 auto 30px;
    opacity: 0.9;
}

.features {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 30px;
    margin-top: 50px;
}

.feature-card {
    background: white;
    padding: 30px;
    border-radius: 10px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    text-align: center;
    transition: transform 0.3s ease;
    animation: slideUp 0.6s ease-out;
}

.feature-card:hover {
    transform: translateY(-10px);
}

.feature-icon {
    font-size: 3rem;
    margin-bottom: 20px;
}

.feature-card h3 {
    color: #3949ab;
    margin-bottom: 15px;
}

@keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
}

@keyframes slideUp {
    from { opacity: 0; transform: translateY(30px); }
    to { opacity: 1; transform: translateY(0); }
}

.cta-buttons {
    display: flex;
    gap: 20px;
    justify-content: center;
    flex-wrap: wrap;
    margin-top: 30px;
}
");

$this->registerJs("
// Анимация для карточек при прокрутке
function animateOnScroll() {
    var cards = document.querySelectorAll('.feature-card');
    
    cards.forEach(function(card, index) {
        var cardPosition = card.getBoundingClientRect().top;
        var screenPosition = window.innerHeight / 1.3;
        
        if (cardPosition < screenPosition) {
            card.style.animationDelay = (index * 0.2) + 's';
            card.classList.add('animated');
        }
    });
}

window.addEventListener('scroll', animateOnScroll);
// Запускаем сразу
animateOnScroll();
");
?>

<?php if (Yii::$app->user->isGuest): ?>
<div class="site-index">
    <div class="hero">
        <h1>📋 Система отдела кадров</h1>
        <p>Современная платформа для управления персоналом, регистрации сотрудников и ведения кадрового учета</p>
        
        <div class="cta-buttons">
            <?= Html::a('Войти в систему', ['site/login'], [
                'class' => 'btn',
                'style' => 'background: white; color: #3949ab; padding: 12px 40px; font-weight: bold;'
            ]) ?>
            
            <?= Html::a('Регистрация', ['site/register'], [
                'class' => 'btn',
                'style' => 'background: transparent; border: 2px solid white; color: white; padding: 12px 40px; font-weight: bold;'
            ]) ?>
        </div>
    </div>

    <div class="features">
        <div class="feature-card">
            <div class="feature-icon">👤</div>
            <h3>Регистрация сотрудников</h3>
            <p>Быстрая и удобная регистрация новых сотрудников с автоматической валидацией данных</p>
        </div>
        
        <div class="feature-card">
            <div class="feature-icon">📄</div>
            <h3>Заполнение анкет</h3>
            <p>Подробные анкеты с поддержкой загрузки документов и автоматическим сохранением</p>
        </div>
        
        <div class="feature-card">
            <div class="feature-icon">🔐</div>
            <h3>Безопасность данных</h3>
            <p>Надежная защита персональных данных сотрудников и конфиденциальной информации</p>
        </div>
        
        <div class="feature-card">
            <div class="feature-icon">📊</div>
            <h3>Управление данными</h3>
            <p>Удобная административная панель для управления и фильтрации данных сотрудников</p>
        </div>
    </div>
</div>

<?php else: ?>
    <?php 
    if (Yii::$app->user->identity->isAdmin()) {
        echo $this->render('//admin/index');
    } else {
        echo $this->render('//profile/index');
    }
    ?>
<?php endif; ?>